@echo off


set APP1=chip-1-nox-tiltrotator-gateway-v1.5.0+gefcabae3.dfu


set DFU_UTIL=updater\dfu-util.exe
set STM_DFU_UPDATE=updater\stm-dfu-update.exe


echo "USB verbinden"
PAUSE


"%STM_DFU_UPDATE%" --name "vcm-1" --discard-settings --importnosave "{"""trigger bootloader""": true}"
CALL :CHECK_FAIL

echo "triggered bootloader uC1"

timeout /T 2 /nobreak
sleep 2

"%DFU_UTIL%" -d 0483:df11 -D %APP1%
if NOT ["%errorlevel%"]==["0"] (
    echo "could not update uC1 with DFU Util, trying STM DFU UPDATE"
    echo [43merror[0m
    
    "%STM_DFU_UPDATE%" --discard-settings %APP1%
    CALL :CHECK_FAIL
) ELSE (	
    "%DFU_UTIL%" -a 0 -d 0483:df11 -s :leave
)

echo [92mfinished update[0m
echo "power cycle needed, then press any key"
PAUSE
"%STM_DFU_UPDATE%" --name "vcm-1" --import enableEndResistor.json
CALL :CHECK_FAIL

echo [92mfinished[0m

:: ======== FN ======
GOTO :EOF

:: /// check if the app has failed
:CHECK_FAIL

if NOT ["%errorlevel%"]==["0"] (
    echo [41merror[0m
    PAUSE
    exit
)